document.addEventListener("DOMContentLoaded", () => {

	// Header dropdown nav menu
	const navButton = document.querySelector('#navToggle');
	if (navButton) {
		const menu = document.querySelector('.nav-wrapper');
		if (menu) {
			navButton.addEventListener('click', (e) => {
				e.preventDefault();
				menu.classList.toggle('shown');
				navButton.classList.toggle('active');
			});
		}
	}

	// Footer accordion (all sections visible at 768px and wider)
	document.querySelectorAll('#footer .list').forEach(footerSection => {
		const heading = footerSection.querySelector('h3');
		if (heading) {
			const menu = footerSection.querySelector('ul');
			if (menu) {
				heading.addEventListener('click', (e) => {
					e.preventDefault();
					if (window.innerWidth < 768) {
						menu.classList.toggle('shown');
					}
				})
			}
		}
	})
});
